<?php
/*------------------------------------------------------------------------
# "Hot Swipe Carousel" Joomla module
# Copyright (C) 2015-2022 HotThemes. All Rights Reserved.
# License: http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
# Author: HotThemes
# Website: https://www.hotjoomlatemplates.com
-------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access'); // no direct access

// get the document object
$doc = JFactory::getDocument();

// load jQuery
JHtml::_('jquery.framework');

// load scripts
$doc->addScript($mosConfig_live_site.'/modules/mod_hot_swipe_carousel/js/flickity.pkgd.min.js');
if($animationType) {
    $doc->addScript($mosConfig_live_site.'/modules/mod_hot_swipe_carousel/js/flickity-fade.js');
}

// add your stylesheet
$doc->addStyleSheet( 'modules/mod_hot_swipe_carousel/tmpl/style.css' );

// style declaration
$doc->addStyleDeclaration( '

.hot_swipe_carousel_slides'.$uniqueid.' .contents {
    top: '.$textAreaTop.';
    left: '.$textAreaLeft.';
    width: '.$textAreaWidth.';
    color: '.$textColor.';
    padding: '.$textAreaPadding.';
    background: rgba('.$boxBgColor.','.$boxTransparency.');
    font-size:'.$textSize.'px;
    opacity:0;
}

.hot_swipe_carousel_slides'.$uniqueid.' .contents h2 {
    font-size:'.$headingSize.'px;
    color: '.$headingTextColor.';
}

.hot_swipe_carousel_slides'.$uniqueid.' img {
    max-width: 99999px;
    width: 100%;
}

.hot_swipe_carousel_slides'.$uniqueid.' .contents {
    position: absolute;
}

' );

if($fullWidth) {

$doc->addStyleDeclaration( '

.hot_swipe_carousel_slides'.$uniqueid.' .gallery-cell {
    width: 100%;
}

' );

}else{

$doc->addStyleDeclaration( '

.hot_swipe_carousel_slides'.$uniqueid.' .gallery-cell {
    width: '.$slideWidth.';
    margin-right: '.$slideMargin.';
}

' );

}

if($textAreaCenter) {

$doc->addStyleDeclaration( '

.hot_swipe_carousel_slides'.$uniqueid.' .contents {
    left:0;
    right:0;
    margin-left:auto;
    margin-right:auto;
}

' );

}

if($textResponsiveBelow) {

$doc->addStyleDeclaration( '
@media (max-width: '.$textResponsiveBelow.') {
    .hot_swipe_carousel_slides'.$uniqueid.' .contents {
        position: relative;
        width: 100% !important;
        background: #000;
        padding: 0 15px 15px 15px;
    }
}

' );

}

if($animationType) {

$doc->addStyleDeclaration( '
.hot_swipe_carousel_slides'.$uniqueid.'.flickity-enabled.is-fade .flickity-slider > * {
    pointer-events: none;
    z-index: 0;
}

.hot_swipe_carousel_slides'.$uniqueid.'.flickity-enabled.is-fade .flickity-slider > .is-selected {
    pointer-events: auto;
    z-index: 1;
}
' );

}
?>

<div class="hot_swipe_carousel_slides<?php echo $uniqueid; ?>">
    <?php
        for ($loop = 1; $loop <= $slides_number; $loop += 1) {
            if ($enableSlide[$loop] == "true") {

                // let's check if retina slide image exists
                $enable_retina_image = false;
                $slide_name_array = [];
                $slide_name_parts = 0;
                $slide_name_without_extension = "";
                $slide_name_part = "";
                $slide_name_without_extension = "";
                $slide_retina_image = "";

                $slide_name_array = explode(".", $image[$loop]);
                $slide_name_parts = count($slide_name_array);

                foreach ($slide_name_array as $slide_name_part) {

                    if($slide_name_part != end($slide_name_array)) {
                        $slide_name_without_extension = $slide_name_without_extension . $slide_name_part . ".";
                    }

                }

                // remove the last dot
                $slide_name_without_extension = rtrim($slide_name_without_extension, ".");

                // this is retina slide image
                $slide_retina_image = $slide_name_without_extension.'-2x.'.end($slide_name_array);

                // check if retina image exists for slide
                if (file_exists($slide_retina_image)) {
                    $enable_retina_image = true;
                }
                ?>
                <div class="gallery-cell">
                    <img <?php if($enable_retina_image == true) { echo 'srcset="'.$mosConfig_live_site.'/'.$slide_retina_image.' 2x"'; } ?> src="<?php echo $mosConfig_live_site.'/'.$image[$loop]; ?>" alt="<?php echo $imageAlt[$loop]; ?>" />
                    <?php if ($imageHeading[$loop] || $imageText[$loop]) { ?>
                    <div class="contents">
                        <?php if ($imageHeading[$loop]) { ?>
                        <h2><?php echo $imageHeading[$loop]; ?></h2>
                        <?php }
                        
                        // retina images in slide content
                        $regex      = '#<img(.*?)>#s';
                        $matches    = array();
                        $fileNameExtension = "-2x";

                        // find all instances of <img> and put in $matches
                        preg_match_all($regex, $imageText[$loop], $matches, PREG_SET_ORDER);

                        foreach ($matches as $match) {
            
                            // Isolate string inside src of the <img>
                            preg_match("/src=\"([^\"]*)\"/", $match[1], $image_src);
                            
                            // Image name without extension:
                            // Since image name can contain dots, we should explode string per .
                            // Then join all elements, except the last element.

                            $image_name_without_extension = "";
                            if (isset($image_src[1])) {
                                $image_name_array = explode(".", $image_src[1]);
                            }
                            $image_name_parts = count($image_name_array);

                            foreach ($image_name_array as $image_name_part) {

                                if($image_name_part != end($image_name_array)) {
                                    $image_name_without_extension = $image_name_without_extension . $image_name_part . ".";
                                }

                            }

                            // remove the last dot
                            $image_name_without_extension = rtrim($image_name_without_extension, ".");

                            // this is retina image
                            $retina_image = $image_name_without_extension.$fileNameExtension.'.'.end($image_name_array);

                            // if retina image exists AND if there's no srcset already defined
                            // add srcset to the <img>

                            $srcset_exists = strpos($match[1], "srcset");

                            if (file_exists($retina_image) && $srcset_exists === false) {
                                $output = '<img srcset="'.JURI::base().$image_name_without_extension.$fileNameExtension.'.'.end($image_name_array).' 2x"' . $match[1] . '>';
                                $imageText[$loop] = preg_replace( "#<img($match[1])>#s", $output , $imageText[$loop] );
                            }

                            // END retina image code
                        }
                        echo $imageText[$loop]; ?>  
                    </div>
                    <?php } ?>
                </div>
        <?php
            }
        }
        ?>
</div>

<script>
    jQuery(document).ready(function(){
        jQuery('.hot_swipe_carousel_slides<?php echo $uniqueid; ?>').flickity({
            // options
            initialIndex: <?php echo $initialIndex; ?>,
            draggable: <?php if($draggable) { echo "true"; }else{ echo "false"; } ?>,
            cellAlign: 'left',
            contain: true,
            freeScroll: false,
            wrapAround: <?php if($wrapAround) { echo "true"; }else{ echo "false"; } ?>,
            prevNextButtons: <?php if($navArrows) { echo "true"; }else{ echo "false"; } ?>,
            pageDots: <?php if($navDots) { echo "true"; }else{ echo "false"; } ?>,
            autoPlay: <?php echo $pauseTime; ?>,
            pauseAutoPlayOnHover: <?php if($pauseOnHover) { echo "true"; }else{ echo "false"; } ?>,
            imagesLoaded: true<?php if ($fullWidth == 0) { ?>,
            "percentPosition": false<?php } ?>,
            <?php if($animationType) { ?>
            fade: true
            <?php } ?>
        });
        jQuery('.hot_swipe_carousel_slides<?php echo $uniqueid; ?> .contents').css('opacity', 1);
    });
</script>