<?php
/*------------------------------------------------------------------------
# "Sparky Framework" - Joomla Template Framework
# Copyright (C) 2022 HotThemes. All Rights Reserved.
# License: http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
# Author: HotThemes
# Website: https://www.hotjoomlatemplates.com
-------------------------------------------------------------------------*/

if(!defined('DS')) {
    define("DS", DIRECTORY_SEPARATOR);
}

$template_current_template_name = $_REQUEST['SPARKY_CURRENT_TEMPLATE_NAME'];

define( 'SPARKYPARENTPATH', getcwd() . DS . '..' . DS . '..' . DS . '..' . DS . 'media' . DS . 'templates' . DS . 'site' . DS . 'sparky_framework' );
define( 'SPARKYEXPORTPATH', getcwd() . DS . '..' . DS . '..' . DS . '..' . DS . 'media' . DS . 'templates' . DS . 'site' . DS . 'sparky_framework' . DS . 'export' );
define( 'SPARKYSOURCETEMPLATEPATH', getcwd() . DS . '..' . DS . '..' . DS . '..' . DS . 'media' . DS . 'templates' . DS . 'site' . DS . $template_current_template_name );
define( 'CURRENTTEMPLATEPATH', getcwd() . DS . '..' . DS . '..' . DS . $template_current_template_name );

$template_child_name = $_REQUEST['SPARKY_EXPORT_NAME'];
$template_child_name = str_ireplace(' ','_', $template_child_name);
$template_child_name = strtolower($template_child_name);

$template_child_options = $_REQUEST['SPARKY_TEMPLATE_OPTIONS'];
$template_child_options = htmlspecialchars_decode($template_child_options);
$template_child_options_object = json_decode($template_child_options);

$template_params = json_decode($template_child_options_object[0]->params);

// Create child template folder

mkdir(SPARKYEXPORTPATH . DS . $template_child_name);


// Create media folders and blank files

mkdir(SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media');

// css

mkdir(SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css');
copy(SPARKYSOURCETEMPLATEPATH . DS . 'css' . DS . $template_params->exportedcssfile, SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'sparky-initial.css');
copy(SPARKYSOURCETEMPLATEPATH . DS . 'css' . DS . 'custom_rtl.css', SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'custom_rtl.css');
$customcss = '';
if(file_get_contents(SPARKYSOURCETEMPLATEPATH . DS . 'css' . DS . 'custom.css') != '') {
	$customcss .= file_get_contents(SPARKYSOURCETEMPLATEPATH . DS . 'css' . DS . 'custom.css');
	$customcss .= "

	";
}
$customcss .= $template_params->customcodecss;
file_put_contents(SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'custom.css',$customcss);
file_put_contents(SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'index.html',"<html><body></body></html>");
mkdir(SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'styles');
file_put_contents(SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'styles' . DS . 'index.html',"<html><body></body></html>");
copy(SPARKYSOURCETEMPLATEPATH . DS . 'css' . DS . 'styles' . DS . 'style2.css', SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'styles' . DS . 'style2.css');
copy(SPARKYSOURCETEMPLATEPATH . DS . 'css' . DS . 'styles' . DS . 'style3.css', SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'styles' . DS . 'style3.css');
copy(SPARKYSOURCETEMPLATEPATH . DS . 'css' . DS . 'styles' . DS . 'style4.css', SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'styles' . DS . 'style4.css');
copy(SPARKYSOURCETEMPLATEPATH . DS . 'css' . DS . 'styles' . DS . 'style5.css', SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'styles' . DS . 'style5.css');
copy(SPARKYSOURCETEMPLATEPATH . DS . 'css' . DS . 'styles' . DS . 'style6.css', SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'styles' . DS . 'style6.css');
copy(SPARKYSOURCETEMPLATEPATH . DS . 'css' . DS . 'styles' . DS . 'style7.css', SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'styles' . DS . 'style7.css');
copy(SPARKYSOURCETEMPLATEPATH . DS . 'css' . DS . 'styles' . DS . 'style8.css', SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'css' . DS . 'styles' . DS . 'style8.css');

// images

mkdir(SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'images');

$images_source = SPARKYSOURCETEMPLATEPATH . DS . 'images';
$images_dest = SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'images';

foreach (
 $iterator = new \RecursiveIteratorIterator(
  new \RecursiveDirectoryIterator($images_source, \RecursiveDirectoryIterator::SKIP_DOTS),
  \RecursiveIteratorIterator::SELF_FIRST) as $item
) {
  if ($item->isDir()) {
    mkdir($images_dest . DS . $iterator->getSubPathname());
  } else {
    copy($item, $images_dest . DS . $iterator->getSubPathname());
  }
}

// js

mkdir(SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'js');
copy(SPARKYSOURCETEMPLATEPATH . DS . 'js' . DS . $template_params->exportedjsfile, SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'js' . DS . 'sparky-initial.js');
copy(SPARKYSOURCETEMPLATEPATH . DS . 'js' . DS . $template_params->exportedjsfooterfile, SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'js' . DS . 'sparky-footer-initial.js');
file_put_contents(SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'js' . DS . 'index.html',"<html><body></body></html>");
$customjs = '';
if(file_get_contents(SPARKYSOURCETEMPLATEPATH . DS . 'js' . DS . 'custom.js') != '') {
	$customjs .= file_get_contents(SPARKYSOURCETEMPLATEPATH . DS . 'js' . DS . 'custom.js');
	$customjs .= "

	";
}
$customjs .= $template_params->customcodejs;
file_put_contents(SPARKYEXPORTPATH . DS . $template_child_name . DS . 'media' . DS . 'js' . DS . 'custom.js',$customjs);

// overrides

mkdir(SPARKYEXPORTPATH . DS . $template_child_name . DS . 'html');

$html_source = CURRENTTEMPLATEPATH . DS . 'html';
$html_dest = SPARKYEXPORTPATH . DS . $template_child_name . DS . 'html';

foreach (
 $iterator = new \RecursiveIteratorIterator(
  new \RecursiveDirectoryIterator($html_source, \RecursiveDirectoryIterator::SKIP_DOTS),
  \RecursiveIteratorIterator::SELF_FIRST) as $item
) {
  if ($item->isDir()) {
    mkdir($html_dest . DS . $iterator->getSubPathname());
  } else {
    copy($item, $html_dest . DS . $iterator->getSubPathname());
  }
}

// Generate templateDetails.xml file

$templateDetailsXML =
'<?xml version="1.0" encoding="utf-8"?>
<extension version="4.0" type="template" client="site" method="upgrade">

	<name>'.$template_child_name.'</name>
	<author>HotThemes</author>
	<copyright>Copyright '.date("Y").' by HotThemes</copyright>
	<authorEmail>info@hotjoomlatemplates.com</authorEmail>
	<authorUrl>https://www.hotjoomlatemplates.com</authorUrl>
	<version>1.0.0</version>
	<description>'.$template_child_name.' child template</description>
	<inheritable>0</inheritable>
	<parent>sparky_framework</parent>
	<creationDate>'.date("F").' '.date("Y").'</creationDate>

	<files>
		<filename>templateDetails.xml</filename>
		<folder>html/</folder>
	</files>

	<media destination="templates/site/'.$template_child_name.'" folder="media">
		<folder>css</folder>
		<folder>images</folder>
		<folder>js</folder>
	</media>

	<positions>
		<position>copyright</position>
		<position>fontresize</position>
		<position>logo</position>
		<position>abovecontent</position>
		<position>belowcontent</position>
		<position>advert1</position>
		<position>advert2</position>
		<position>advert3</position>
		<position>advert4</position>
		<position>advert5</position>
		<position>advert6</position>
		<position>bottom1</position>
		<position>bottom2</position>
		<position>bottom3</position>
		<position>bottom4</position>
		<position>bottom5</position>
		<position>bottom6</position>
		<position>footer</position>
		<position>header1</position>
		<position>header2</position>
		<position>header3</position>
		<position>header4</position>
		<position>header5</position>
		<position>header6</position>
		<position>left</position>
		<position>right</position>
		<position>search</position>
		<position>top1</position>
		<position>top2</position>
		<position>top3</position>
		<position>top4</position>
		<position>top5</position>
		<position>top6</position>
		<position>user1</position>
		<position>user2</position>
		<position>user3</position>
		<position>user4</position>
		<position>user5</position>
		<position>user6</position>
		<position>megamenu1</position>
		<position>megamenu2</position>
		<position>megamenu3</position>
		<position>megamenu4</position>
		<position>megamenu5</position>
		<position>megamenu6</position>
		<position>megamenu7</position>
		<position>megamenu8</position>
		<position>megamenu9</position>
		<position>megamenu10</position>
		<position>settings</position>
	</positions>

	<config>
		<fields name="params" addfieldpath="/templates/sparky_framework/elements" enctype="multipart/form-data">
			<fieldset name="layoutdesign" label="TPL_SPARKY_FRAMEWORK_LAYOUT_DESIGN">
				<field type="tadmin"/>
				<field name="layoutdesign" type="designlayout" label="TPL_SPARKY_FRAMEWORK_LAYOUT_DESIGN_LBL" default="'.htmlentities($template_params->layoutdesign).'"/>
				<field name="gridSystem" type="width" default="'.$template_params->gridSystem.'" min="1" max="24" label="TPL_SPARKY_FRAMEWORK_GRID_NUMBER" description="TPL_SPARKY_FRAMEWORK_GRID_NUMBER_DESC"/>
				<field name="templateWidth" type="dimension" default="'.$template_params->templateWidth.'" label="TPL_SPARKY_FRAMEWORK_TEMPLATE_WIDTH_LBL" description="TPL_SPARKY_FRAMEWORK_TEMPLATE_WIDTH_DESC"/>
				<field name="cellPaddingHorizontal" type="dimension" default="'.$template_params->cellPaddingHorizontal.'" label="TPL_SPARKY_FRAMEWORK_CELL_PADDING_HORIZONTAL_LBL" description="TPL_SPARKY_FRAMEWORK_CELL_PADDING_HORIZONTAL_DESC" />
				<field name="cellPaddingVertical" type="dimension" default="'.$template_params->cellPaddingVertical.'" label="TPL_SPARKY_FRAMEWORK_CELL_PADDING_VERTICAL_LBL" description="TPL_SPARKY_FRAMEWORK_CELL_PADDING_VERTICAL_DESC" />
			</fieldset>
			<fieldset name="fontsettings" label="TPL_SPARKY_FRAMEWORK_STYLE_DESIGNER">
				<field name="subtabstart1" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_FEATURES_BACKGROUND_LBL"/>
					<field name="bodyBgColor" type="predefinedcolor" label="TPL_SPARKY_FRAMEWORK_BODY_BG_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC" default="'.$template_params->bodyBgColor.'"/>
					<field name="bodyBgImageFile" type="imagelist" label="TPL_SPARKY_FRAMEWORK_BG_IMAGE_LBL" description="TPL_SPARKY_FRAMEWORK_IMAGE_SELECT_DESC" default="'.$template_params->bodyBgImageFile.'" directory="media/templates/site/'.$template_child_name.'/images" />
					<field name="bodyBgImageVerticalAlign" type="list" default="'.$template_params->bodyBgImageVerticalAlign.'" label="TPL_SPARKY_FRAMEWORK_BG_IMAGE_VERTICAL_ALIGN_LBL" description="TPL_SPARKY_FRAMEWORK_BG_IMAGE_VERTICAL_ALIGN_DESC">
						<option value="top">TPL_SPARKY_FRAMEWORK_TOP</option>
						<option value="center">TPL_SPARKY_FRAMEWORK_CENTER</option>
						<option value="bottom">TPL_SPARKY_FRAMEWORK_BOTTOM</option>
					</field>
					<field name="bodyBgImageHorizontalAlign" type="list" default="'.$template_params->bodyBgImageHorizontalAlign.'" label="TPL_SPARKY_FRAMEWORK_BG_IMAGE_HORIZONTAL_ALIGN_LBL" description="TPL_SPARKY_FRAMEWORK_BG_IMAGE_HORIZONTAL_ALIGN_DESC">
						<option value="left">TPL_SPARKY_FRAMEWORK_LEFT</option>
						<option value="center">TPL_SPARKY_FRAMEWORK_CENTER</option>
						<option value="right">TPL_SPARKY_FRAMEWORK_RIGHT</option>
					</field>
					<field name="bodyBgImageRepeat" type="list" default="'.$template_params->bodyBgImageRepeat.'" label="TPL_SPARKY_FRAMEWORK_BG_IMAGE_REPEAT_LBL" description="TPL_SPARKY_FRAMEWORK_BG_IMAGE_REPEAT_DESC">
						<option value="repeat">TPL_SPARKY_FRAMEWORK_BG_IMAGE_REPEAT_REPEAT_LBL</option>
						<option value="repeat-x">TPL_SPARKY_FRAMEWORK_BG_IMAGE_REPEAT_REPEAT_HORIZONTALLY_LBL</option>
						<option value="repeat-y">TPL_SPARKY_FRAMEWORK_BG_IMAGE_REPEAT_REPEAT_VERTICALLY_LBL</option>
						<option value="no-repeat">TPL_SPARKY_FRAMEWORK_BG_IMAGE_REPEAT_NO_REPEAT_LBL</option>
					</field>
					<field name="bodyBgImageFixedSwitch" type="flipyesno" default="'.$template_params->bodyBgImageFixedSwitch.'" label="TPL_SPARKY_FRAMEWORK_BODY_BG_IMAGE_FIXED_SWITCH_LBL" description="TPL_SPARKY_FRAMEWORK_BODY_BG_IMAGE_FIXED_SWITCH_DESC"/>
					<field name="containerBgColor" type="predefinedcolor" label="TPL_SPARKY_FRAMEWORK_CONTAINER_BG_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC" default="'.$template_params->containerBgColor.'"/>
				<field name="subtabstart2" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_H1_LBL"/>
					<field name="h1Color" type="predefinedcolor" default="'.$template_params->h1Color.'" label="TPL_SPARKY_FRAMEWORK_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC" />
					<field name="h1Size" type="dimension" default="'.$template_params->h1Size.'" label="TPL_SPARKY_FRAMEWORK_FONT_SIZE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_SIZE_DESC" />
					<field name="h1LineHeight" type="number" default="'.$template_params->h1LineHeight.'" label="TPL_SPARKY_FRAMEWORK_FONT_LINE_HEIGHT_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_LINE_HEIGHT_DESC" size="3" />
					<field name="h1FontHot" type="hotfont" default="'.htmlentities($template_params->h1FontHot).'" label="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_DESC"/>
					<field name="h1Align" type="list" default="'.$template_params->h1Align.'" label="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_LBL" description="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_DESC">
						<option value="">TPL_SPARKY_FRAMEWORK_DEFAULT</option>
						<option value="left">TPL_SPARKY_FRAMEWORK_LEFT</option>
						<option value="center">TPL_SPARKY_FRAMEWORK_CENTER</option>
						<option value="right">TPL_SPARKY_FRAMEWORK_RIGHT</option>
					</field>
					<field name="h1Underline" type="flipyesno" default="'.$template_params->h1Underline.'" label="TPL_SPARKY_FRAMEWORK_FONT_UNDERLINE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_UNDERLINE_DESC"/>
				<field name="subtabstart3" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_H2_LBL"/>
					<field name="h2Color" type="predefinedcolor" default="'.$template_params->h2Color.'" label="TPL_SPARKY_FRAMEWORK_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC" />
					<field name="h2Size" type="dimension" default="'.$template_params->h2Size.'" label="TPL_SPARKY_FRAMEWORK_FONT_SIZE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_SIZE_DESC" />
					<field name="h2LineHeight" type="number" default="'.$template_params->h2LineHeight.'" label="TPL_SPARKY_FRAMEWORK_FONT_LINE_HEIGHT_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_LINE_HEIGHT_DESC" size="3" />
					<field name="h2FontHot" type="hotfont" default="'.htmlentities($template_params->h2FontHot).'" label="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_DESC"/>
					<field name="h2Align" type="list" default="'.$template_params->h2Align.'" label="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_LBL" description="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_DESC">
						<option value="">TPL_SPARKY_FRAMEWORK_DEFAULT</option>
						<option value="left">TPL_SPARKY_FRAMEWORK_LEFT</option>
						<option value="center">TPL_SPARKY_FRAMEWORK_CENTER</option>
						<option value="right">TPL_SPARKY_FRAMEWORK_RIGHT</option>
					</field>
					<field name="h2Underline" type="flipyesno" default="'.$template_params->h2Underline.'" label="TPL_SPARKY_FRAMEWORK_FONT_UNDERLINE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_UNDERLINE_DESC"/>
				<field name="subtabstart4" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_H3_LBL"/>
					<field name="h3Color" type="predefinedcolor" default="'.$template_params->h3Color.'" label="TPL_SPARKY_FRAMEWORK_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC" />
					<field name="h3Size" type="dimension" default="'.$template_params->h3Size.'" label="TPL_SPARKY_FRAMEWORK_FONT_SIZE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_SIZE_DESC" />
					<field name="h3LineHeight" type="number" default="'.$template_params->h3LineHeight.'" label="TPL_SPARKY_FRAMEWORK_FONT_LINE_HEIGHT_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_LINE_HEIGHT_DESC" size="3" />
					<field name="h3FontHot" type="hotfont" default="'.htmlentities($template_params->h3FontHot).'" label="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_DESC"/>
					<field name="h3Align" type="list" default="'.$template_params->h3Align.'" label="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_LBL" description="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_DESC">
						<option value="">TPL_SPARKY_FRAMEWORK_DEFAULT</option>
						<option value="left">TPL_SPARKY_FRAMEWORK_LEFT</option>
						<option value="center">TPL_SPARKY_FRAMEWORK_CENTER</option>
						<option value="right">TPL_SPARKY_FRAMEWORK_RIGHT</option>
					</field>
					<field name="h3Underline" type="flipyesno" default="'.$template_params->h3Underline.'" label="TPL_SPARKY_FRAMEWORK_FONT_UNDERLINE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_UNDERLINE_DESC"/>
				<field name="subtabstart5" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_H4_LBL"/>
					<field name="h4Color" type="predefinedcolor" default="'.$template_params->h4Color.'" label="TPL_SPARKY_FRAMEWORK_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="h4Size" type="dimension" default="'.$template_params->h4Size.'" label="TPL_SPARKY_FRAMEWORK_FONT_SIZE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_SIZE_DESC" />
					<field name="h4LineHeight" type="number" default="'.$template_params->h4LineHeight.'" label="TPL_SPARKY_FRAMEWORK_FONT_LINE_HEIGHT_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_LINE_HEIGHT_DESC" size="3" />
					<field name="h4FontHot" type="hotfont" default="'.htmlentities($template_params->h4FontHot).'" label="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_DESC"/>
					<field name="h4Align" type="list" default="'.$template_params->h4Align.'" label="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_LBL" description="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_DESC">
						<option value="">TPL_SPARKY_FRAMEWORK_DEFAULT</option>
						<option value="left">TPL_SPARKY_FRAMEWORK_LEFT</option>
						<option value="center">TPL_SPARKY_FRAMEWORK_CENTER</option>
						<option value="right">TPL_SPARKY_FRAMEWORK_RIGHT</option>
					</field>
					<field name="h4Underline" type="flipyesno" default="'.$template_params->h4Underline.'" label="TPL_SPARKY_FRAMEWORK_FONT_UNDERLINE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_UNDERLINE_DESC"/>
				<field name="subtabstart6" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_P_LBL"/>
					<field name="pColor" type="predefinedcolor" default="'.$template_params->pColor.'" label="TPL_SPARKY_FRAMEWORK_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="pSize" type="dimension" default="'.$template_params->pSize.'" label="TPL_SPARKY_FRAMEWORK_FONT_SIZE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_SIZE_DESC" />
					<field name="pLineHeight" type="number" default="'.$template_params->pLineHeight.'" label="TPL_SPARKY_FRAMEWORK_FONT_LINE_HEIGHT_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_LINE_HEIGHT_DESC" size="3" />
					<field name="pFontHot" type="hotfont" default="'.htmlentities($template_params->pFontHot).'" label="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_DESC"/>
					<field name="pAlign" type="list" default="'.$template_params->pAlign.'" label="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_LBL" description="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_DESC">
						<option value="">TPL_SPARKY_FRAMEWORK_DEFAULT</option>
						<option value="left">TPL_SPARKY_FRAMEWORK_LEFT</option>
						<option value="center">TPL_SPARKY_FRAMEWORK_CENTER</option>
						<option value="right">TPL_SPARKY_FRAMEWORK_RIGHT</option>
						<option value="justify">TPL_SPARKY_FRAMEWORK_JUSTIFY</option>
					</field>
				<field name="subtabstart7" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_LINKS_LBL"/>
					<field name="linksColor" type="predefinedcolor" default="'.$template_params->linksColor.'" label="TPL_SPARKY_FRAMEWORK_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="linksHoverColor" type="predefinedcolor" default="'.$template_params->linksHoverColor.'" label="TPL_SPARKY_FRAMEWORK_HOVER_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="linksWeight" type="list" default="'.$template_params->linksWeight.'" label="TPL_SPARKY_FRAMEWORK_FONT_WEIGHT_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_WEIGHT_DESC">
						<option value="100">100</option>
						<option value="200">200</option>
						<option value="300">300</option>
						<option value="normal">Normal</option>
						<option value="500">500</option>
						<option value="600">600</option>
						<option value="bold">Bold</option>
						<option value="800">800</option>
						<option value="900">900</option>
					</field>
					<field name="linksStyle" type="list" default="'.$template_params->linksStyle.'" label="TPL_SPARKY_FRAMEWORK_FONT_STYLE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_STYLE_DESC">
						<option value="normal">Normal</option>
						<option value="italic">Italic</option>
					</field>
					<field name="linksUnderline" type="flipyesno" default="'.$template_params->linksUnderline.'" label="TPL_SPARKY_FRAMEWORK_FONT_UNDERLINE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_UNDERLINE_DESC"/>
					<field name="linksUnderlineHover" type="flipyesno" default="'.$template_params->linksUnderlineHover.'" label="TPL_SPARKY_FRAMEWORK_FONT_UNDERLINE_HOVER_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_UNDERLINE_DESC"/>
				<field name="subtabstart8" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_SELECT_STYLE"/>
					<field name="templateStyleIntro1" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_TEMPLATE_COLORS_TEXT1"/>
					<field name="sparkycolor1" type="color" default="'.$template_params->sparkycolor1.'" label="TPL_SPARKY_FRAMEWORK_TEMPLATE_COLOR1" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="sparkycolor2" type="color" default="'.$template_params->sparkycolor2.'" label="TPL_SPARKY_FRAMEWORK_TEMPLATE_COLOR2" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="sparkycolor3" type="color" default="'.$template_params->sparkycolor3.'" label="TPL_SPARKY_FRAMEWORK_TEMPLATE_COLOR3" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="sparkycolor4" type="color" default="'.$template_params->sparkycolor4.'" label="TPL_SPARKY_FRAMEWORK_TEMPLATE_COLOR4" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="sparkycolor5" type="color" default="'.$template_params->sparkycolor5.'" label="TPL_SPARKY_FRAMEWORK_TEMPLATE_COLOR5" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="sparkycolor6" type="color" default="'.$template_params->sparkycolor6.'" label="TPL_SPARKY_FRAMEWORK_TEMPLATE_COLOR6" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="templateStyleIntro2" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_TEMPLATE_COLORS_TEXT2"/>
					<field name="templateStyle" type="list" default="'.$template_params->templateStyle.'" label="TPL_SPARKY_FRAMEWORK_SELECT_TEMPLATE_STYLE">
						<option value="1">TPL_SPARKY_FRAMEWORK_SELECT_STYLE1</option>
						<option value="2">TPL_SPARKY_FRAMEWORK_SELECT_STYLE2</option>
						<option value="3">TPL_SPARKY_FRAMEWORK_SELECT_STYLE3</option>
						<option value="4">TPL_SPARKY_FRAMEWORK_SELECT_STYLE4</option>
						<option value="5">TPL_SPARKY_FRAMEWORK_SELECT_STYLE5</option>
						<option value="6">TPL_SPARKY_FRAMEWORK_SELECT_STYLE6</option>
						<option value="7">TPL_SPARKY_FRAMEWORK_SELECT_STYLE7</option>
						<option value="8">TPL_SPARKY_FRAMEWORK_SELECT_STYLE8</option>
					</field>
					<field name="templateStyleIntro3" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_TEMPLATE_COLORS_TEXT3"/>
					<field name="palette1" type="text" label="TPL_SPARKY_FRAMEWORK_SELECT_STYLE1" description="" default="'.$template_params->palette1.'"/>
					<field name="palette2" type="text" label="TPL_SPARKY_FRAMEWORK_SELECT_STYLE2" description="" default="'.$template_params->palette2.'"/>
					<field name="palette3" type="text" label="TPL_SPARKY_FRAMEWORK_SELECT_STYLE3" description="" default="'.$template_params->palette3.'"/>
					<field name="palette4" type="text" label="TPL_SPARKY_FRAMEWORK_SELECT_STYLE4" description="" default="'.$template_params->palette4.'"/>
					<field name="palette5" type="text" label="TPL_SPARKY_FRAMEWORK_SELECT_STYLE5" description="" default="'.$template_params->palette5.'"/>
					<field name="palette6" type="text" label="TPL_SPARKY_FRAMEWORK_SELECT_STYLE6" description="" default="'.$template_params->palette6.'"/>
					<field name="palette7" type="text" label="TPL_SPARKY_FRAMEWORK_SELECT_STYLE7" description="" default="'.$template_params->palette7.'"/>
					<field name="palette8" type="text" label="TPL_SPARKY_FRAMEWORK_SELECT_STYLE8" description="" default="'.$template_params->palette8.'"/>
			</fieldset>
			<fieldset name="features" label="TPL_SPARKY_FRAMEWORK_FEATURES">
				<field name="subtabstart1" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_FEATURES_BRANDING_LBL"/>
					<field name="logoImageSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_LOGO_IMAGE_SETTINGS_LBL"/>
					<field name="logoImageFile" type="imagelist" label="TPL_SPARKY_FRAMEWORK_LOGO_IMAGE_FILE_LBL" description="TPL_SPARKY_FRAMEWORK_IMAGE_SELECT_DESC" directory="media/templates/site/'.$template_child_name.'/images" default="'.$template_params->logoImageFile.'" />
					<field name="logoImageAlt" type="text" label="TPL_SPARKY_FRAMEWORK_LOGO_IMAGE_ALT_LBL" description="TPL_SPARKY_FRAMEWORK_LOGO_IMAGE_ALT_DESC" default="'.htmlentities($template_params->logoImageAlt).'"/>
					<field name="logoImageStyles" type="flipyesno" default="'.$template_params->logoImageStyles.'" label="TPL_SPARKY_FRAMEWORK_LOGO_IMAGE_STYLES_LBL" description="TPL_SPARKY_FRAMEWORK_LOGO_IMAGE_STYLES_DESC"/>
					<field name="logoTextSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_LOGO_SETTINGS_LBL"/>
					<field name="logoTextSpacerIntro" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_LOGO_SETTINGS_INTRO_LBL"/>
					<field name="logoText" type="text" label="TPL_SPARKY_FRAMEWORK_LOGO_TEXT_LBL" description="TPL_SPARKY_FRAMEWORK_LOGO_TEXT_DESC" default="'.htmlentities($template_params->logoText).'" filter="raw"/>
					<field name="logoColor" type="predefinedcolor" label="TPL_SPARKY_FRAMEWORK_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC" default="'.$template_params->logoColor.'"/>
					<field name="logoSize" type="dimension" label="TPL_SPARKY_FRAMEWORK_FONT_SIZE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_SIZE_DESC" default="'.$template_params->logoSize.'" />
					<field name="logoFontHot" type="hotfont" default="'.htmlentities($template_params->logoFontHot).'" label="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_DESC"/>
					<field name="logoAlign" type="list" default="'.$template_params->logoAlign.'" label="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_LBL" description="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_DESC">
						<option value="">TPL_SPARKY_FRAMEWORK_DEFAULT</option>
						<option value="left">TPL_SPARKY_FRAMEWORK_LEFT</option>
						<option value="center">TPL_SPARKY_FRAMEWORK_CENTER</option>
						<option value="right">TPL_SPARKY_FRAMEWORK_RIGHT</option>
					</field>
					<field name="sloganTextSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_SLOGAN_SETTINGS_LBL"/>
					<field name="sloganText" type="text" label="TPL_SPARKY_FRAMEWORK_SLOGAN_TEXT_LBL" description="TPL_SPARKY_FRAMEWORK_SLOGAN_TEXT_DESC" default="'.htmlentities($template_params->sloganText).'" filter="raw"/>
					<field name="sloganColor" type="predefinedcolor" label="TPL_SPARKY_FRAMEWORK_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC" default="'.$template_params->sloganColor.'"/>
					<field name="sloganSize" type="dimension" label="TPL_SPARKY_FRAMEWORK_FONT_SIZE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_SIZE_DESC" default="'.$template_params->sloganSize.'" />
					<field name="sloganFontHot" type="hotfont" default="'.htmlentities($template_params->sloganFontHot).'" label="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_DESC"/>
					<field name="sloganAlign" type="list" default="'.$template_params->sloganAlign.'" label="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_LBL" description="TPL_SPARKY_FRAMEWORK_TEXT_ALIGN_DESC">
						<option value="">TPL_SPARKY_FRAMEWORK_DEFAULT</option>
						<option value="left">TPL_SPARKY_FRAMEWORK_LEFT</option>
						<option value="center">TPL_SPARKY_FRAMEWORK_CENTER</option>
						<option value="right">TPL_SPARKY_FRAMEWORK_RIGHT</option>
					</field>
					<field name="faviconSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_FAVICONS_LBL"/>
					<field name="favicon" type="imagelist" label="TPL_SPARKY_FRAMEWORK_BROWSER_BAR_ICON_LBL" description="TPL_SPARKY_FRAMEWORK_BROWSER_BAR_ICON_DESC" default="'.$template_params->favicon.'" directory="media/templates/site/'.$template_child_name.'/images/icons" exclude="png|gif|jpg" />
					<field name="appleicon" type="imagelist" label="TPL_SPARKY_FRAMEWORK_APPLE_ICON_LBL" description="TPL_SPARKY_FRAMEWORK_APPLE_ICON_DESC" default="'.$template_params->appleicon.'" directory="media/templates/site/'.$template_child_name.'/images/icons" exclude="gif|jpg" />
					<field name="androidicon" type="imagelist" label="TPL_SPARKY_FRAMEWORK_ANDROID_ICON_LBL" description="TPL_SPARKY_FRAMEWORK_ANDROID_ICON_DESC" default="'.$template_params->androidicon.'" directory="media/templates/site/'.$template_child_name.'/images/icons" exclude="gif|jpg" />
					<field name="copyrightSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_COPYRIGHT_SETTINGS_LBL"/>
					<field name="copyright" type="text" default="'.htmlentities($template_params->copyright).'" label="TPL_SPARKY_FRAMEWORK_LABEL_COPYRIGHT" />
					<field name="googleUrl" type="hidden" default="'.htmlentities($template_params->googleUrl).'" value="" />
				<field name="subtabstart2" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_FEATURES_TOPPANEL_LBL"/>
					<field name="topPanelSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_DESC"/>
					<field name="topPanelSwitch" type="flipyesno" default="'.$template_params->topPanelSwitch.'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_SWITCH_LBL" description="TPL_SPARKY_FRAMEWORK_TOP_PANEL_SWITCH_DESC"/>
					<field name="topPanelOpen" type="text" default="'.htmlentities($template_params->topPanelOpen).'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_OPEN_LBL"/>
					<field name="topPanelClose" type="text" default="'.htmlentities($template_params->topPanelClose).'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_CLOSE_LBL"/>
					<field name="topPanelButtonWidth" type="dimension" default="'.$template_params->topPanelButtonWidth.'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_BUTTON_WIDTH_LBL" />
					<field name="topPanelButtonHeight" type="dimension" default="'.$template_params->topPanelButtonHeight.'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_BUTTON_HEIGHT_LBL" />
					<field name="topPanelButtonBgColor" type="predefinedcolor" default="'.$template_params->topPanelButtonBgColor.'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_BUTTON_BG_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="topPanelButtonTextColor" type="predefinedcolor" default="'.$template_params->topPanelButtonTextColor.'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_BUTTON_TEXT_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="topPanelButtonTextSize" type="dimension" default="'.$template_params->topPanelButtonTextSize.'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_BUTTON_TEXT_SIZE_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_SIZE_DESC" /> 
					<field name="topPanelButtonBorderColor" type="predefinedcolor" default="'.$template_params->topPanelButtonBorderColor.'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_BUTTON_BORDER_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="topPanelButtonBorderRadius" type="number" default="'.$template_params->topPanelButtonBorderRadius.'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_BUTTON_BORDER_RADIUS_LBL" size="3" />
					<field name="topPanelBgColor" type="predefinedcolor" default="'.$template_params->topPanelBgColor.'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_BG_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="topPanelH3Color" type="predefinedcolor" default="'.$template_params->topPanelH3Color.'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_H3_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
					<field name="topPanelTextColor" type="predefinedcolor" default="'.$template_params->topPanelTextColor.'" label="TPL_SPARKY_FRAMEWORK_TOP_PANEL_TEXT_COLOR_LBL" description="TPL_SPARKY_FRAMEWORK_COLOR_DESC"/>
				<field name="subtabstart3" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_FEATURES_FONT_RESIZE_LBL"/>
					<field name="fontResizeSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_FONT_RESIZE_DESC"/>
					<field name="fontResizeMinus" type="text" default="'.htmlentities($template_params->fontResizeMinus).'" label="TPL_SPARKY_FRAMEWORK_FONT_RESIZE_MINUS_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_RESIZE_MINUS_DESC" filter="raw"/>
					<field name="fontResizeReset" type="text" default="'.htmlentities($template_params->fontResizeReset).'" label="TPL_SPARKY_FRAMEWORK_FONT_RESIZE_RESET_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_RESIZE_RESET_DESC" filter="raw"/>
					<field name="fontResizePlus" type="text" default="'.htmlentities($template_params->fontResizePlus).'" label="TPL_SPARKY_FRAMEWORK_FONT_RESIZE_PLUS_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_RESIZE_PLUS_DESC" filter="raw"/>
				<field name="subtabstart5" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_GOOGLE_WEB_FONTS_LBL"/>
					<field name="fontHot" type="hotfontfeatures" default="" label="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_LBL" description="TPL_SPARKY_FRAMEWORK_FONT_FAMILY_DESC"/>
				<field name="subtabstart6" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_SCROLL_TO_TOP_LBL"/>
					<field name="scrollToTopSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_SCROLL_TO_TOP_SPACER_DESC"/>
					<field name="scrollToTopImageFile" type="imagelist" label="TPL_SPARKY_FRAMEWORK_SCROLL_TO_TOP_IMAGE_FILE_LBL" description="TPL_SPARKY_FRAMEWORK_IMAGE_SELECT_DESC" default="'.$template_params->scrollToTopImageFile.'" directory="media/templates/site/'.$template_child_name.'/images" />
					<field name="scrollToTopPosition" type="list" default="'.$template_params->scrollToTopPosition.'" label="TPL_SPARKY_FRAMEWORK_SCROLL_TO_TOP_POSITION_LBL" description="TPL_SPARKY_FRAMEWORK_SCROLL_TO_TOP_POSITION_DESC">
						<option value="bottom_right">TPL_SPARKY_FRAMEWORK_SCROLL_TO_TOP_POSITION_BOTTOM_RIGHT</option>
						<option value="bottom_left">TPL_SPARKY_FRAMEWORK_SCROLL_TO_TOP_POSITION_BOTTOM_LEFT</option>
						<option value="top_right">TPL_SPARKY_FRAMEWORK_SCROLL_TO_TOP_POSITION_TOP_RIGHT</option>
						<option value="top_left">TPL_SPARKY_FRAMEWORK_SCROLL_TO_TOP_POSITION_TOP_LEFT</option>
					</field>
				<field name="subtabstart8" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_IMAGE_ANIMATION_LBL"/>
					<field name="imageAnimationSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_IMAGE_ANIMATION_DESC"/>
					<field name="imageAnimation" type="flipyesno" default="'.$template_params->imageAnimation.'" label="TPL_SPARKY_FRAMEWORK_IMAGE_ANIMATION_LOAD_LBL" description="TPL_SPARKY_FRAMEWORK_IMAGE_ANIMATION_LOAD_DESC"/>
				<field name="subtabstart9" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_PAGE_TRANSITIONS"/>
					<field name="pageTransitionSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_PAGE_TRANSITION_DESC"/>
					<field name="pageTransition" type="flipyesno" default="'.$template_params->pageTransition.'" label="TPL_SPARKY_FRAMEWORK_PAGE_TRANSITION_ENABLE" />
					<field name="pageTransitionDelay" type="number" default="'.$template_params->pageTransitionDelay.'" label="TPL_SPARKY_FRAMEWORK_PAGE_TRANSITION_DELAY" description="TPL_SPARKY_FRAMEWORK_PAGE_TRANSITION_DELAY_DESC" size="3" />
					<field name="pageTransitionBg" type="predefinedcolor" label="TPL_SPARKY_FRAMEWORK_BACKGROUND_COLOR" description="TPL_SPARKY_FRAMEWORK_PAGE_TRANSITION_BG_COLOR_DESC" default="'.$template_params->pageTransitionBg.'"/>
					<field name="pageTransitionSpinner" type="list" default="'.$template_params->pageTransitionSpinner.'" label="TPL_SPARKY_FRAMEWORK_PAGE_TRANSITION_SPINNER" description="TPL_SPARKY_FRAMEWORK_PAGE_TRANSITION_SPINNER_DESC">
						<option value="spinner1">TPL_SPARKY_FRAMEWORK_TWO_GROWING_CIRCLES</option>
						<option value="spinner2">TPL_SPARKY_FRAMEWORK_ROTATING_SMALL_CIRCLES</option>
						<option value="spinner3">TPL_SPARKY_FRAMEWORK_TWO_ROTATING_GROWING_CIRCLES</option>
						<option value="spinner4">TPL_SPARKY_FRAMEWORK_ROTATING_SQUARE</option>
						<option value="spinner5">TPL_SPARKY_FRAMEWORK_TWO_SMALL_SQUARES</option>
						<option value="spinner6">TPL_SPARKY_FRAMEWORK_PULSING_RECTANGLES</option>
						<option value="spinner7">TPL_SPARKY_FRAMEWORK_PULSING_CIRCLES</option>
					</field>
					<field name="pageTransitionImage" type="imagelist" label="TPL_SPARKY_FRAMEWORK_USE_BG_IMAGE" description="TPL_SPARKY_FRAMEWORK_PAGE_TRANSITION_BG_IMAGE_DESC" default="'.$template_params->pageTransitionImage.'" directory="media/templates/site/'.$template_child_name.'/images" />
				<field name="subtabstart10" type="spacer" default="" label="TPL_SPARKY_FRAMEWORK_SCRIPTS_LBL"/>
					<field name="loadBootstrapSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_LOAD_BOOTSTRAP_SPACER"/>
					<field name="loadBootstrap" type="flipyesno" default="'.$template_params->loadBootstrap.'" label="TPL_SPARKY_FRAMEWORK_LOAD_BOOTSTRAP_LBL" description="TPL_SPARKY_FRAMEWORK_LOAD_BOOTSTRAP_DESC"/>
					<field name="loadJqueryUISpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_LOAD_JQUERYUI_SPACER"/>
					<field name="loadJqueryUI" type="flipyesno" default="'.$template_params->loadJqueryUI.'" label="TPL_SPARKY_FRAMEWORK_LOAD_JQUERYUI_LBL" description="TPL_SPARKY_FRAMEWORK_LOAD_JQUERYUI_DESC"/>
					<field name="loadFontAwesomeSpacer" type="hotspacer" label=""/>
					<field name="loadFontAwesome" type="flipyesno" default="'.$template_params->loadFontAwesome.'" label="TPL_SPARKY_FRAMEWORK_LOAD_FONTAWESOME_LBL" description="TPL_SPARKY_FRAMEWORK_LOAD_FONTAWESOME_DESC"/>
					<field name="loadFontAwesomeSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_LOAD_FONTAWESOME_SPACER"/>
					<field name="lazyLoadSpacer" type="hotspacer" label="TPL_SPARKY_FRAMEWORK_LOAD_LAZYLOAD_SPACER"/>
					<field name="lazyLoad" type="flipyesno" default="'.$template_params->lazyLoad.'" label="TPL_SPARKY_FRAMEWORK_LOAD_LAZYLOAD_LBL" description="TPL_SPARKY_FRAMEWORK_LOAD_LAZYLOAD_DESC"/>
			</fieldset>
			<fieldset name="menuconfig" label="TPL_SPARKY_FRAMEWORK_MENUS">
			    <field name="mnucfg" type="mnucfg" default="'.htmlentities($template_params->mnucfg).'" label="TPL_SPARKY_FRAMEWORK_MENUCFG_LBL" description="TPL_SPARKY_FRAMEWORK_MNUCFG_DESC"/>
			</fieldset>
			<fieldset name="mobileoptions" label="TPL_SPARKY_FRAMEWORK_MOBILE">
				<field name="enableResponsive" type="flipyesno" default="'.$template_params->enableResponsive.'" label="TPL_SPARKY_FRAMEWORK_ENABLE_RESPONSIVE_LBL" description="TPL_SPARKY_FRAMEWORK_ENABLE_RESPONSIVE_DESC"/>
				<field name="enableResponsiveMenu" type="flipyesno" default="'.$template_params->enableResponsiveMenu.'" label="TPL_SPARKY_FRAMEWORK_ENABLE_RESPONSIVE_MENU_LBL" description="TPL_SPARKY_FRAMEWORK_ENABLE_RESPONSIVE_MENU_DESC"/>
				<field name="responsiveMenuTriggerValue" type="dimension" default="'.$template_params->responsiveMenuTriggerValue.'" label="TPL_SPARKY_FRAMEWORK_RESPONSIVE_MENU_TRIGGER_LBL" description="TPL_SPARKY_FRAMEWORK_RESPONSIVE_MENU_TRIGGER_DESC" />
				<field name="menuIconImage" type="imagelist" label="TPL_SPARKY_FRAMEWORK_MENU_ICON_IMAGE_LBL" description="TPL_SPARKY_FRAMEWORK_IMAGE_SELECT_DESC" default="'.$template_params->menuIconImage.'" directory="media/templates/site/'.$template_child_name.'/images" />
		    </fieldset>
		    <fieldset name="customcode" label="TPL_SPARKY_FRAMEWORK_CUSTOM">
		    	<field name="subtabstart1" type="spacer" default="1" label="CSS"/>
		    		<field name="customcodeSpacer" type="spacer" label="TPL_SPARKY_FRAMEWORK_CUSTOM_CSS_CODE_DESC"/>
					<field name="customcodecss" type="textarea" cols="50" rows="3" label="" filter="raw" default=""/>
				<field name="subtabstart2" type="spacer" default="1" label="JavaScript"/>
					<field name="customcodeSpacer2" type="spacer" label="TPL_SPARKY_FRAMEWORK_CUSTOM_JS_CODE_DESC"/>
					<field name="customcodejs" type="textarea" cols="50" rows="3" label="" filter="raw" default=""/>
				<field name="subtabstart3" type="spacer" default="1" label="&lt; head &gt;"/>
					<field name="customcodeSpacer3" type="spacer" label="TPL_SPARKY_FRAMEWORK_CUSTOM_HEAD_CODE_DESC"/>
					<field name="customhead" type="textarea" cols="50" rows="3" label="" filter="raw" default="'.htmlentities($template_params->customhead).'"/>
		    </fieldset>
			<fieldset name="exportoptions" label="TPL_SPARKY_FRAMEWORK_EXPORT_OPTIONS">
				<field name="export" type="hotexport" default="" label="" description="TPL_SPARKY_FRAMEWORK_DESC_EXPORT" />
				<field name="exportedcssfile" type="hidden" default="sparky-initial.css" value="" />
				<field name="exportedjsfile" type="hidden" default="sparky-initial.js" value="" />
				<field name="exportedjsfooterfile" type="hidden" default="sparky-footer-initial.js" value=""/>
			</fieldset>
			<fieldset name="premiumtab" label="NEWS">
				<field name="premium" type="premium" default="" label="" />
			</fieldset>
	    </fields>
	</config>

</extension>';

file_put_contents(SPARKYEXPORTPATH . DS . $template_child_name . DS . 'templateDetails.xml', $templateDetailsXML);


// ZIP child template files

// delete old zip archive with the same name (if it exists)
if (file_exists(SPARKYEXPORTPATH . DS . $template_child_name.".zip")) {
	unlink(SPARKYEXPORTPATH . DS . $template_child_name.".zip");
}

// Get real path for our folder
$rootPath = realpath(SPARKYEXPORTPATH . DS . $template_child_name);

// Initialize archive object
$zip = new ZipArchive();
$zip->open($template_child_name.'.zip', ZipArchive::CREATE | ZipArchive::OVERWRITE);

// Create recursive directory iterator
/** @var SplFileInfo[] $files */
$files = new RecursiveIteratorIterator(
    new RecursiveDirectoryIterator($rootPath),
    RecursiveIteratorIterator::LEAVES_ONLY
);

foreach ($files as $name => $file)
{
    // Skip directories (they would be added automatically)
    if (!$file->isDir())
    {
        // Get real and relative path for current file
        $filePath = $file->getRealPath();
        $relativePath = substr($filePath, strlen($rootPath) + 1);

        // Add current file to archive
        $zip->addFile($filePath, $relativePath);
    }
}

// Zip archive will be created only after closing object
$zip->close();

// move Zip archive
rename($template_child_name.".zip", SPARKYEXPORTPATH . DS . $template_child_name.".zip");

// Delete exported folder
function rrmdir($dir) { 
	if (is_dir($dir)) { 
 		$objects = scandir($dir);
 		foreach ($objects as $object) { 
   			if ($object != "." && $object != "..") { 
     			if (is_dir($dir. DIRECTORY_SEPARATOR .$object) && !is_link($dir."/".$object))
       				rrmdir($dir. DIRECTORY_SEPARATOR .$object);
     		else
       			unlink($dir. DIRECTORY_SEPARATOR .$object); 
   			} 
 		}
 		rmdir($dir); 
	} 
}
rrmdir(SPARKYEXPORTPATH . DS . $template_child_name);


// Success message

echo "The child template \"" . $template_child_name . "\" exported to /media/templates/site/sparky_framework/export";

?>