<?php
/*------------------------------------------------------------------------
# "Sparky Framework" - Joomla Template Framework
# Copyright (C) 2022 HotThemes. All Rights Reserved.
# License: http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
# Author: HotThemes
# Website: https://www.hotjoomlatemplates.com
-------------------------------------------------------------------------*/

defined('JPATH_BASE') or die;

jimport('joomla.form.formfield');

/**
 * Form Field class for the Joomla Framework.
 *
 * @package		Joomla.Framework
 * @subpackage	Form
 * @since		1.6
 */
class JFormFieldHotexport extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'hotexport';

	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
	    $OUT= '';
	    ob_start();
		
		$jbase = str_ireplace("/administrator", "", JURI::base());

		// get params for template style that's being edited
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query
			->select('params')
			->from('#__template_styles')
			->where('id=' . $_GET['id']);

		$db->setQuery($query);
		$db->execute();

		$templateOptionsObject = $db->loadObjectList();
		$templateOptions = json_encode($templateOptionsObject);
		$templateOptions = htmlentities($templateOptions);

		// get current template name
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query
			->select('template')
			->from('#__template_styles')
			->where('id=' . $_GET['id']);

		$db->setQuery($query);
		$db->execute();

		$templateNameObject = $db->loadObjectList();
		$templateName = $templateNameObject[0]->template;
		?>
			<div class="control-group">
				<div class="control-label">
					<label for="<?php echo $this->id; ?>">
						<?php echo jText::sprintf("TPL_SPARKY_FRAMEWORK_LABEL_EXPORT") ?>
					</label>
				</div>
				<div class="controls">
					<p><input onkeyup="document.getElementById(this.id + '_alias').innerHTML = this.value.toLowerCase().replace(/ /g,'_');return false;" type="text" name="SPARKY_EXPORT_NAME" id="<?php echo $this->id; ?>" value="" /></p>
					<input type="hidden" value="<?php echo $templateName; ?>" name="SPARKY_CURRENT_TEMPLATE_NAME">
					<input type="hidden" value="<?php echo $templateOptions ?>" name="SPARKY_TEMPLATE_OPTIONS">
					<p><button class="btn btn-primary" style="margin:0" onclick="doExport('<?php echo $jbase; ?>','templates/sparky_framework/elements/doexport.php',jQuery('#<?php echo $this->id; ?>').val());return false;">Export</button></p>
					<p><span style="width:120px;" id="<?php echo $this->id; ?>_alias"></span></p>
				</div>
			</div>
			
		<?php
		$OUT = ob_get_contents();
        ob_end_clean();		
        return $OUT;

	}
}
