<?php
/**
 * @version		$Id: default.php 22355 2011-11-07 05:11:58Z github_bot $
 * @package		Joomla.Site
 * @subpackage	mod_menu
 * @copyright	Copyright (C) 2005 - 2011 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access.
defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $app->getDocument()->getWebAssetManager();
$wa->registerAndUseScript('mod_menu', 'mod_menu/menu.min.js', [], ['defer' => true]);

$id = '';

if ($tagId = $params->get('tag_id', ''))
{
	$id = ' id="' . $tagId . '"';
}

// Note. It is important to remove spaces between elements.

global $mnucfg;
$sparky_mnu = '';
 
if(isset($mnucfg)){
	if ( isset($mnucfg[$params->get('menutype')]['type']) ) {
		$sparky_mnu = $mnucfg[$params->get('menutype')]['type'];
	}
  
 	if( $sparky_mnu == "navv" ||  $sparky_mnu == "navh" ||  $sparky_mnu == "acc" ||  $sparky_mnu == "offcanvas" || $sparky_mnu == "mega" ){
		$params->set('showAllChildren',1);
	}
}

if( $sparky_mnu == "offcanvas" ) { ?><div class="offcanvas-btn"></div><?php } ?>

<nav class="container_<?php echo $params->get('menutype'); if( $sparky_mnu == "offcanvas" ) { echo " offcanvas-".$mnucfg[$params->get('menutype')]["offcanvas_position"]; } ?>">

	<?php
	if( $sparky_mnu == "offcanvas" && $mnucfg[$params->get('menutype')]["content_before_menu"] ) {
		echo '<div class="offcanvas_before_menu">'.$mnucfg[$params->get('menutype')]["content_before_menu"].'</div>';
	}
	?>
	<ul<?php echo $id; ?> class="menu mod-menu nav<?php echo $class_sfx; ?> mod-list <?php if ($sparky_mnu!="none") { echo $sparky_mnu."_sparky"; echo ' mnu_'.$params->get('menutype'); } ?>">
		<?php foreach ($list as $i => &$item)
		{
			$itemParams = $item->getParams();
			$class      = 'nav-item item-' . $item->id;

			if ($item->id == $default_id)
			{
				$class .= ' default';
			}

			if ($item->id == $active_id || ($item->type === 'alias' && $itemParams->get('aliasoptions') == $active_id))
			{
				$class .= ' current';
			}

			if (in_array($item->id, $path))
			{
				$class .= ' active';
			}
			elseif ($item->type === 'alias')
			{
				$aliasToId = $itemParams->get('aliasoptions');

				if (count($path) > 0 && $aliasToId == $path[count($path) - 1])
				{
					$class .= ' active';
				}
				elseif (in_array($aliasToId, $path))
				{
					$class .= ' alias-parent-active';
				}
			}

			if ($item->type === 'separator')
			{
				$class .= ' divider';
			}

			if ($item->deeper)
			{
				$class .= ' deeper';
			}

			if ($item->parent)
			{
				$class .= ' parent';
			}

			echo '<li class="' . $class . '">';

			switch ($item->type) :
				case 'separator':
				case 'component':
				case 'heading':
				case 'url':
					require ModuleHelper::getLayoutPath('mod_menu', 'default_' . $item->type);
					break;

				default:
					require ModuleHelper::getLayoutPath('mod_menu', 'default_url');
					break;
			endswitch;

			// The next item is deeper.
			if ($item->deeper)
			{
				echo '<ul class="mod-menu__sub list-unstyled small">';
			}
			// The next item is shallower.
			elseif ($item->shallower)
			{
				echo '</li>';
				echo str_repeat('</ul></li>', $item->level_diff);
			}
			// The next item is on the same level.
			else
			{
				echo '</li>';
			}
		}
		?>
	</ul>

	<?php
	if( $sparky_mnu == "offcanvas" && $mnucfg[$params->get('menutype')]["content_after_menu"] ) {
		echo '<div class="offcanvas_after_menu">'.$mnucfg[$params->get('menutype')]["content_after_menu"].'</div>';
	}
	?>
</nav>